#version 140
#extension GL_EXT_gpu_shader4 : enable

//Mouse Offset MandelbrotMod01.fsh
//https://www.shadertoy.com/view/NlcSRj

// Licence CC0
// Adapted, trivialy, for use in VGHD player


uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
// -----------------------------------------------------------------------------
#define iTime   u_Elapsed  //* 0.366 
//#define texture2D texture2D_Fract
#define iGlobalTime iTime
//#define RESOLUTION      iResolution
#define iResolution      u_WindowSize
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
uniform sampler2D iChannel0;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}



#define PI 3.141592653
#define AA 2.

vec3 colMap(float v) {
 v=mod(v, PI+1.3)-.8;
 return vec3(
  sin(sin(v-.6)),
  sin(sin(v)),
  sin(sin(v+.8))
  );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
  float aaFract = 1./AA;
  for(float aa=0.; aa<1.; aa+=aaFract){
      for(float bb=0.; bb<1.; bb+=aaFract){
          vec2 uv =  ( (gl_FragCoord.yx + vec2(aa,bb) ) -.5* iResolution.yx ) / iResolution.x;
          uv*=(-cos(iTime*.1)+1.3)*.28;
          uv+=vec2(.1,.65);

          vec2 c =uv;
          vec2 z=c;
          float l=0.;
          float sum=length(z);
          vec2 newZ;
          for(int i=0;i<40;i++){
           c+=(iMouse.yx/iResolution.yx  -.5)*-.01*float(i);
            newZ=vec2(-z.y*z.y+z.x*z.x, 2.*z.x*z.y)+c;
            sum+=length(newZ-z);
            z=newZ;
            l=length(z);
            if(l>2.) break;
          }
          vec2 dir=z-c;
          vec3 col = vec3(dir, .0);

          uv.x=mod((atan(dir.y,dir.x)/PI*.5+.5)*6.+(iTime+sin(iTime)*.9)*4., 1.);
          uv.y=mod(length(dir*.5),1.);

          col=colMap(sum*.2-l*.1+iTime*.1).gbr;

          gl_FragColor += vec4(col.grb, 1.0) * aaFract*aaFract;
        }
    }
}
